(
	-- UV Generator 

    struct AMGData 
	(
		fn GetUUID mtl context =
		(
			"d472fb22-9c8d-44f4-bcaa-cef1dd62cc61"
		),

		fn GetMaps mtl context =
		(
			local res = #()	

			-- If we have an UVW override, we just use that...
			if (AMG_UVW_override != undefined) then
			(
				join res AMG_uvw_override
			)
			else
			(
				-- Environment mode cannot use varying attributes
				if (mtl.mappingType == 0 and context != 2) do
				(
					append res #("uvw",      undefined, "uvw_"       + (mtl.mapChannel as String))
					append res #("utangent", undefined, "u_tangent_" + (mtl.mapChannel as String))
					append res #("vtangent", undefined, "v_tangent_" + (mtl.mapChannel as String))
				)
			)

			res
		),

		fn GetParams mtl context =
		(
			local res = #()	

			append res #("mapSlotType",   mtl.mappingType)
			append res #("mapType",       mtl.mapping)     
			append res #("showMapOnBack", mtl.showMapOnBack)

			append res #("utile", mtl.U_Tile)
			append res #("vtile", mtl.V_Tile)
			append res #("umirror", mtl.U_Mirror)
			append res #("vmirror", mtl.V_Mirror)

			-- Thankfully, all the transform-craziness gets baked into this one parameter.... <3 you max
			append res #("UVTransform", mtl.UVTransform)
			append res #("TangentTransform", orthogonalize(inverse(mtl.UVTransform)))

			append res #("blur",      mtl.blur) 
			append res #("blurOffs",  mtl.Blur_Offset) 

			append res #("ns",     mtl.Noise_On) 
			append res #("nsAni",  mtl.Noise_Animate) 
			append res #("nsAmt",  mtl.Noise_Amount) 
			append res #("nsPhs",  mtl.phase) 
			append res #("nsSize", mtl.Noise_Size) 
			append res #("nsLev",  mtl.Noise_Levels) 
	
 			res
		)
	)

	AMGData()
)